//+------------------------------------------------------------------+
//|                                             Squeeze Straddle.mq4 |
//|                                       Copyright  2006, Akuma99. |
//|                                    http://www.beginnertrader.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Akuma99."
#property link      "http://www.beginnertrader.com"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_color3 Green
#property indicator_color4 Green

extern int        distance=20;
extern int        totalBars=3000;
extern int        bolPrd=12;
extern double     bolDev=2.0;
extern int        keltPrd=6;
extern double     keltFactor=1;
extern bool       emailAlert=false;

double upK[];
double loK[];
double clouds1[];
double clouds2[];

int init() {
   
   SetIndexStyle(0,DRAW_LINE,EMPTY,1,indicator_color1);
   SetIndexBuffer(0,upK);
   
   SetIndexStyle(1,DRAW_LINE,EMPTY,1,indicator_color2);
   SetIndexBuffer(1,loK);
   
   SetIndexStyle(2,DRAW_HISTOGRAM, 2, 1, indicator_color3);
   SetIndexBuffer(2, clouds1);

   SetIndexStyle(3,DRAW_HISTOGRAM, 2, 1, indicator_color4);
   SetIndexBuffer(3, clouds2);

   return(0);
}

int start() {
   
   int counted_bars=IndicatorCounted();
   int shift,limit;
   double diff1,std1,bbs1,diff2,std2,bbs2,dis,ema1,ema2;
   
   if (counted_bars<0) return(-1);
   limit=totalBars;
   
   dis = iATR(NULL,0,24,shift)*1.5;

   for (shift=limit;shift>=0;shift--)   {
      
		diff1 = iATR(NULL,0,keltPrd,shift)*keltFactor;
		std1 = iStdDev(NULL,0,bolPrd,MODE_SMA,0,PRICE_CLOSE,shift);
		bbs1 = bolDev * std1 / diff1;
		
		diff2 = iATR(NULL,0,keltPrd,shift+1)*keltFactor;
		std2 = iStdDev(NULL,0,bolPrd,MODE_SMA,0,PRICE_CLOSE,shift+1);
		bbs2 = bolDev * std2 / diff2;
		
		ema1 = iMA(NULL,0,10,0,MODE_EMA,PRICE_CLOSE,shift);
		ema2 = iMA(NULL,0,50,0,MODE_EMA,PRICE_CLOSE,shift);
		
		clouds1[shift] = ema1;
      clouds2[shift] = ema2;
      
      Print ("clouds = ", ema2);
		
      if(bbs1 < 1 && bbs2 > 1) {
      
         //upK[shift]=Close[shift+1]+dis;
         //loK[shift]=Close[shift+1]-dis;
            
      } else {
         
         //upK[shift] = upK[shift+1];
         //loK[shift] = loK[shift+1];
         
      }
      
   }
   
   return(0);
   
  }
//+------------------------------------------------------------------+

